/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.patron_pet.player;

import com.alexander.mutantmore.patron_pet.player.PlayerPatronPetData;
import com.alexander.mutantmore.patron_pet.player.PlayerPatronPetDataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mutantmore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PatronPetDataEvents {
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerPatronPetDataProvider.PLAYER_PATRON_PET_DATA).isPresent()) {
            event.addCapability(new ResourceLocation("mutantmore", "playerpatronpetdata"), (ICapabilityProvider)new PlayerPatronPetDataProvider());
        }
    }

    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(PlayerPatronPetDataProvider.PLAYER_PATRON_PET_DATA).ifPresent(oldStore -> event.getEntity().getCapability(PlayerPatronPetDataProvider.PLAYER_PATRON_PET_DATA).ifPresent(newStore -> newStore.copyFrom((PlayerPatronPetData)oldStore)));
    }

    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerPatronPetData.class);
    }

    public static void setup() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addGenericListener(Entity.class, PatronPetDataEvents::onAttachCapabilitiesPlayer);
        bus.addListener(PatronPetDataEvents::onPlayerCloned);
        bus.addListener(PatronPetDataEvents::onRegisterCapabilities);
    }
}

